/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.deployer;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.kinetics.deployer.DeployerActorVisual;
import com.zurrtum.create.client.content.kinetics.deployer.DeployerRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class DeployerMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new DeployerActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(class_243 camera, class_327 textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        double factor;
        if (VisualizationManager.supportsVisualization((class_1936)context.world)) {
            return null;
        }
        DeployerMovementRenderState state = new DeployerMovementRenderState(context.localPos);
        state.layer = class_12249.method_75965();
        class_2680 blockState = context.state;
        DeployerBlockEntity.Mode mode = context.blockEntityData.method_67491("Mode", DeployerBlockEntity.Mode.CODEC).orElse(DeployerBlockEntity.Mode.PUNCH);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        float speed = context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        state.shaft = CachedBuffers.block(AllBlocks.SHAFT.method_9564());
        state.pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        state.hand = CachedBuffers.partial(handPose, blockState);
        if (context.contraption.stalled || context.position == null || context.data.method_10545("StationaryTimer")) {
            factor = class_3532.method_15374((double)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            class_243 center = VecHelper.getCenterOf((class_2382)class_2338.method_49638((class_2374)context.position));
            double distance = context.position.method_1022(center);
            double nextDistance = context.position.method_1019(context.motion).method_1022(center);
            factor = 0.5 - class_3532.method_15350((double)class_3532.method_16436((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        class_2350 facing = (class_2350)blockState.method_11654(DirectionalKineticBlock.FACING);
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        class_2248 class_22482 = context.state.method_26204();
        if (class_22482 instanceof IRotate) {
            IRotate def = (IRotate)class_22482;
            axis = def.getRotationAxis(context.state);
        }
        float time = AnimationTickHolder.getRenderTime((class_1936)context.world) / 20.0f;
        state.angle = time * speed % 360.0f;
        state.yRot = axis == class_2350.class_2351.field_11051 ? 1.5707964f : 0.0f;
        state.zRot = axis.method_10179() ? 1.5707964f : 0.0f;
        state.light = class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        if (!context.disabled) {
            state.offset = class_243.method_24954((class_2382)facing.method_62675()).method_1021(factor);
        }
        state.upAngle = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.eastAngle = (float)Math.PI / 180 * (float)(facing == class_2350.field_11036 ? 270 : (facing == class_2350.field_11033 ? 90 : 0));
        state.southAngle = (float)Math.PI / 180 * (float)((Boolean)blockState.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2350.class_2351.field_11051 ? 90 : 0);
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DeployerMovementRenderState
    extends MovementRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer shaft;
        public SuperByteBuffer pole;
        public SuperByteBuffer hand;
        public float yRot;
        public float zRot;
        public float angle;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;
        public class_243 offset;
        public float upAngle;
        public float eastAngle;
        public float southAngle;

        public DeployerMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, this.layer, (class_11659.class_11660)this);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.shaft.center()).rotateY(this.yRot)).rotateZ(this.zRot)).uncenter()).rotateCentered(this.angle, class_2350.field_11036)).light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            if (this.offset != null) {
                this.pole.translate(this.offset);
                this.hand.translate(this.offset);
            }
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.pole.rotateCentered(this.upAngle, class_2350.field_11036)).rotateCentered(this.eastAngle, class_2350.field_11034)).rotateCentered(this.southAngle, class_2350.field_11035)).light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)this.hand.rotateCentered(this.upAngle, class_2350.field_11036)).rotateCentered(this.eastAngle, class_2350.field_11034)).light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

